library dotNetAssembly;

//Delphi IID syntax doesn't get respected, so
//we must currently use the Guid attribute
{.$define USE_DELPHI_SYNTAX_IID}

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Drawing.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Windows.Forms,
  System.Runtime.InteropServices;

[assembly: ComVisible(False)]

type
  [ComVisible(True)]
{$ifndef USE_DELPHI_SYNTAX_IID}
  [Guid('3C32D881-43DA-40D2-A7F6-0AE830C2920F')]
{$endif}
  IDotNetInterface = interface(IInterface)
{$ifdef USE_DELPHI_SYNTAX_IID}
  ['{3C32D881-43DA-40D2-A7F6-0AE830C2920F}']
{$endif}
    procedure One(const Msg: String);
    function Two(Input: Integer; out Output: Integer): Boolean;
  end;

  [ComVisible(True)]
  //Don't generate a class interface, since we already have a real interface
  //Just generate a coclass
  [ClassInterface(ClassInterfaceType.None)]
  DotNetObject = class(TObject, IDotNetInterface)
  public
    procedure One(const Msg: String);
    function Two(Input: Integer; out Output: Integer): Boolean;
  end;

procedure DotNetObject.One(const Msg: String);
begin
  MessageBox.Show(Msg, 'Message From .NET', MessageBoxButtons.OK,
    MessageBoxIcon.Information)
end;

function DotNetObject.Two(Input: Integer; out Output: Integer): Boolean;
begin
  Output := 2 * Input;
  Result := True
end;

begin
end.
